#!/usr/bin/env python

# csv2reader.py - given a CSV file with a specific shape, output a set of files ammenable to the Reader

# Eric Lease Morgan <emorgan@nd.edu>
# (c) University of Notre Dame; distributed under a GNU Public License

# January 12, 2024 - first investigations


# configure
CSV       = './etc/ai-responses.csv'
DELIMITER = '@'
EXTENSION = '.txt'
CACHE     = 'comments'
METADATA  = 'metadata.csv'

# require
import pandas as pd
from pathlib import Path

# read the given CSV
responses = pd.read_csv( CSV )

# create title and file columns; easy
responses[ 'file' ]  = ( responses[ 'author' ].str.split( DELIMITER, expand=True ) )[ 0 ] + EXTENSION
responses[ 'title' ] = ( responses[ 'author' ].str.split( DELIMITER, expand=True ) )[ 0 ]

# normalize the qualitative columns and create a comments column
responses[ 'excites' ] = responses[ 'excites' ].astype(str)
responses[ 'more' ]    = responses[ 'more' ].astype(str)
responses[ 'comment' ] = responses[ 'excites' ] + ' ' + responses[ 'more' ]

# make sane
cache = Path( CACHE )
cache.mkdir( exist_ok=True )

# process each row; create a cache of comments
for index, response in responses.iterrows() :

	# parse
	file    = response[ 'file' ]
	comment = response[ 'comment' ]
		
	# save
	with open( cache/file, 'w' ) as handle : handle.write( comment )

# output the metadata and done
with open( cache/METADATA, 'w' ) as handle : handle.write( responses.to_csv( index=False ) )
exit()
