#!/usr/bin/env python

# count-types.py - given a specifically shaped CSV file, count and tabulate specific occurances

# Eric Lease Morgan <emorgan@nd.edu>
# (c) University of Notre Dame; distributed under a GNU Public License

# January 13, 2025 - first cut


# configure 
CSV      = './etc/articles.csv'
COLUMNS  = [ 'types', 'counts' ]

# require
from pandas import read_csv, DataFrame
from sys    import argv, exit

# get input
if len( argv ) != 2 : exit( "Usage: " + argv[ 0 ] + " <custom|international>" )
category = argv[ 1 ]

# read the given csv file
articles = read_csv( CSV )

# select only the given category
category = articles.loc[articles[ 'category' ] == category ]

# count & tabulate, and create a dataframe from the result
counts = category[ 'type' ].value_counts().to_dict()
counts = DataFrame( counts.items(), columns=COLUMNS )

# output and done
print( counts.to_csv( index=False ) )
exit()
