#!/usr/bin/env python

# characters2edgtes.py - given a few configuations, output an edges table of people

# Eric Lease Morgan <eric_morgan@infomotions.com>
# (c) Infomotions, LLC; distributed under a GNU Public License

# August 23, 2025 - first cut
# August 24, 2025 - enhanced list of characters


# configure
CHARACTERS = [ 'emma', 'elton', 'jane', 'harriet', 'frank', 'perry', 'isabella', 'john', 'martin', 'robert', 'james', 'henry', 'selina', 'elizabeth', 'george', 'william', 'hannah', 'hetty' ]
SENTENCES  = './etc/carrel.sents'
HEADER     = [ 'source', 'target', 'weight' ]


# require
from itertools import combinations

# initialize
with open( SENTENCES ) as handle : sentences = handle.read().splitlines()
print( '\t'.join( HEADER ) )

# process each pair of characters
for pair in combinations( CHARACTERS, r=2 ) :

	# re-initialize
	set    = []
	subset = []

	# parse
	character = pair[ 0 ]
	another   = pair[ 1 ]
	
	# create a set of sentences for the given character
	for sentence in sentences :
	
		if character in sentence.lower() : set.append( sentence )
		
	# create a subset of such sentences
	for sentence in set :
	
		if another in sentence.lower() : subset.append( sentence )
		
	# output
	print( '\t'.join( [ character, another, str( len( subset ) ) ] ) )

# done
exit()
