<?xml version='1.0'?>

<!--

MANIFEST.xsl - given an XML document of a specific shape, output HTML

Eric Lease Morgan <emorgan@nd.edu>
(c) University of Notre Dame; distributed under a GNU Public License

July 27, 2021 - first working version

-->
     
		
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  <xsl:output method='html' />
  <xsl:template match='carrel'>
    <html>
      <head>
        <title><xsl:value-of select='./directory/@name' /></title>
		<script>
			function showAndHide( list ) {
				var element = document.getElementById( list );
				if (element.style.display === "none") { element.style.display = "block"; }
				else { element.style.display = "none"; }
			}
		</script>
      </head>
      <body>
		<xsl:attribute name='style'>margin:3%; font-size:large</xsl:attribute>
		<xsl:attribute name='onload'>showAndHide('<xsl:value-of select='/carrel/directory/@name' />')</xsl:attribute>
        <h1>Manifest for <xsl:value-of select='/carrel/directory/@name' /></h1>
        <p>This is a complete listing of all the files and directories found in this study carrel -- <strong><xsl:value-of select='./directory/@name' /></strong>.</p>
        <ul><xsl:apply-templates select='directory' /></ul>
        <hr />
        <p style='text-align: right'>Eric Lease Morgan &lt;<a href='mailto:emorgan@nd.edu'>emorgan@nd.edu</a>&gt;<br />July 25, 2021</p>
      </body>
    </html>
  </xsl:template>

  <xsl:template match='directory'>
    <li>
    	<a>
    		<xsl:attribute name='href'>#</xsl:attribute>
    		<xsl:attribute name='onclick'>showAndHide('<xsl:value-of select='./@name' />')</xsl:attribute>
    		<xsl:value-of select='./@name' />
    	</a>
    	<ol>
			<xsl:attribute name='id'><xsl:value-of select='./@name' /></xsl:attribute>
			<xsl:attribute name='style'>display: none</xsl:attribute>
			<xsl:apply-templates />
    	</ol>
    </li>
  </xsl:template>

  <xsl:template match='file'>
    <li><a>
			<xsl:attribute name='href'>
				<xsl:choose>
				  <xsl:when test="../@name = /carrel/directory/@name">
					<xsl:value-of select="concat( './', ./@name )" />
				  </xsl:when>
				  <xsl:otherwise>
					<xsl:value-of select="concat( ../@name, '/', ./@name )" />
				  </xsl:otherwise>
				</xsl:choose>        	
			</xsl:attribute>
			<xsl:value-of select='@name' />
		</a>
    </li>
  </xsl:template>
  
</xsl:stylesheet>
